/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.m_91087_();
    private XaeroIcon deathSymbolTexture;
    private final Map<String, XaeroIcon> charSymbols = new HashMap<String, XaeroIcon>();
    private XaeroIconAtlasManager iconManager;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private PoseStack matrixStack = new PoseStack();

    public XaeroIcon getDeathSymbolTexture() {
        if (this.deathSymbolTexture == null) {
            this.createDeathSymbolTexture();
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture() {
        this.deathSymbolTexture = this.createCharSymbol(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XaeroIcon getSymbolTexture(String c) {
        XaeroIcon icon;
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            icon = this.charSymbols.get(c);
        }
        if (icon == null) {
            icon = this.createCharSymbol(false, c);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XaeroIcon createCharSymbol(boolean death, String c) {
        if (this.iconManager == null) {
            OpenGLException.checkGLError();
            int maxTextureSize = GlStateManager.m_84092_((int)3379);
            OpenGLException.checkGLError();
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
            this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
            OpenGLException.checkGLError();
            GlStateManager.m_84541_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
            OpenGLException.checkGLError();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
            this.iconManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        }
        XaeroIconAtlas atlas = this.iconManager.getCurrentAtlas();
        XaeroIcon icon = atlas.createIcon();
        this.atlasRenderFramebuffer.m_83947_(false);
        GlStateManager.m_84430_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
        this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
        this.atlasRenderFramebuffer.m_83949_();
        if (this.lastAtlas != atlas) {
            RenderSystem.m_69424_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.m_69421_((int)16384, (boolean)Minecraft.f_91002_);
            this.lastAtlas = atlas;
        }
        Matrix4f ortho = Matrix4f.m_162203_((float)0.0f, (float)64.0f, (float)0.0f, (float)64.0f, (float)-1.0f, (float)1000.0f);
        RenderSystem.m_157425_((Matrix4f)ortho);
        PoseStack shaderMatrixStack = RenderSystem.m_157191_();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.m_157182_();
        PoseStack matrixStack = this.matrixStack;
        matrixStack.m_85836_();
        matrixStack.m_85837_(2.0, 2.0, 0.0);
        if (!death) {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            this.mc.f_91062_.m_92750_(matrixStack, c, 0.0f, 0.0f, -1);
        } else {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)minimapTextures);
            RenderSystem.m_157429_((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)1, (int)1, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.m_157429_((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)0, (int)0, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStack.m_85849_();
        Misc.minecraftOrtho(this.mc);
        shaderMatrixStack.m_85849_();
        RenderSystem.m_157182_();
        this.atlasRenderFramebuffer.m_83970_();
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(this.mc);
        GlStateManager.m_84430_((int)0, (int)0, (int)this.mc.m_91268_().m_85441_(), (int)this.mc.m_91268_().m_85442_());
        if (death) {
            this.deathSymbolTexture = icon;
        } else {
            Map<String, XaeroIcon> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, icon);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            this.charSymbols.clear();
        }
        this.deathSymbolTexture = null;
        if (this.iconManager != null) {
            this.iconManager.clearAtlases();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
        }
    }
}

